import * as GameTest from "GameTest";
import { BlockLocation, MinecraftBlockTypes, Commands, World } from "Minecraft";

const TicksPerSecond = 20;
const FiveSecondsInTicks = 5 * TicksPerSecond;

GameTest.register("CommandTests", "fill_command", (test) => {
    let overworld = World.getDimension("overworld");
    test.startSequence()
        .thenExecute(() => test.setBlockType(MinecraftBlockTypes.concrete, new BlockLocation(1, 2, 1)))
        .thenExecuteAfter(5, () => Commands.run("/execute @e[type=armor_stand,name=\"Fill - Replace - Command\",c=1] ~ ~ ~ fill ~1 ~ ~1 ~1 ~ ~1 concretepowder [\"color\":\"blue\"] replace concrete [\"color\":\"blue\"]", overworld))
        .thenWait(() => {
            test.succeedWhen(() => {
                test.assertBlockPresent(MinecraftBlockTypes.concrete, new BlockLocation(1, 2, 1), true);
            });
        });

})
    .maxTicks(FiveSecondsInTicks)
    .structureName("CommandTests:fill_command")
    .maxAttempts(1);;